/*
Created by: Prateek Rungta http://prateekrungta.com/livescorewidget
based on the Google Desktop Gadget to fetch Live Scores 
http://www.google.com/ig/add?moduleurl=http://www.google.co.in/cricket/igoogle/scores.xml
*/

var donateURL = "https://www.paypal.com/cgi-bin/webscr?cmd=_xclick&business=me%40prateekrungta%2ecom&item_name=Generous%20donation%20for%20the%20Cricket%20Scorecard%20widget&no_shipping=0&no_note=1&tax=0&currency_code=USD&bn=PP%2dDonationsBF&charset=UTF%2d8";
var rungtaURL = "http://prateekrungta.com";
var cricketScoreURL = "http://prateekrungta.com/livescorewidget";

var ajax;	//the XMLHttpRequest object
var scoreURL = "http://www.google.co.in/cricket/cricketscores";
//scoreURL = "http://localhost/~pr/cricket/cricketscores.php"; //debugging URL
var content; //the stuff returned by ajax
var matches; //array of matchInfos contained in content
var nextRefresh; //time before next refresh
var refreshTimer = null;
var failure = 0;

var updateURL = "http://prateekrungta.com/livescorewidget/download/version.php";
//updateURL = "http://localhost/~pr/pr_dyn/livescorewidget/download/version.php";
var versionRequest = null;
var latestVersion;

//Initialising a matchInfo object
function matchInfoObject(matchId)
{
	this.matchId = matchId;
	this.teams = new Array(2);
	this.battingTeam = 0;
	this.bowlingTeam = 1;
	for ( var i = this.teams.length; i--; ) {
		this.teams[i] = new Object();
		this.teams[i].runs = 0;
		this.teams[i].wickets = 0;
		this.teams[i].score = "";
		this.teams[i].balls = 0;
		this.teams[i].overs = 0;
		this.teams[i].extras = 0;
		this.teams[i].runRate = 0.0;
	}
}

function refreshContent () {
	if (ajax != null) {
		failure++;
		ajax.abort();
		ajax = null;
	}
	ajax =  new XMLHttpRequest();
	ajax.onreadystatechange = interpretContent;
	ajax.open("GET", scoreURL);
	ajax.setRequestHeader("Cache-Control", "no-cache");
	ajax.send(null);
}

function interpretContent () {
	if (ajax.readyState == 4 || ajax.readyState == 'complete') {
		var nextRefresh = 7 * 1000;  // for error cases
		if (ajax.status == 200) {
			try {
				content = eval( "(" + ajax.responseText + ")" );
				nextRefresh = content.nextrefreshtime;
				if(content.iserror) {
					failure++;
				} else {
					failure = 0;
					matches = new Array();
					// Getting the total number of current matches
					var numMatches = (content.summaryscore ? content.summaryscore.length : 0 );
					for( var i = 0; i < numMatches; i++ )	{
						var match = content.summaryscore[i];
						var matchInfo = new matchInfoObject(match.matchid);
						matchInfo.teams[0].id = match.teama.id;
						matchInfo.teams[1].id = match.teamb.id;
						matchInfo.teams[0].name = match.teama.name;
						matchInfo.teams[1].name = match.teamb.name;
						matchInfo.matchName = matchInfo.teams[0].name + " vs " + matchInfo.teams[1].name;
						var tossOutcome;
						if ( !(undefined === match.tosswonteam) ) {
							tossOutcome = matchInfo.teams[match.tosswonteam].name + " decided to ";
							switch (match.tossdecision) {
							case 0	: tossOutcome += "bat"; break;
							case 1	: tossOutcome += "bowl"; break;
							}
						} else {
							tossOutcome = "Waiting for toss";
						}
						matchInfo.venue = tossOutcome;
						matchInfo.status = match.matchstatus;
						
						var i2 = 1;
						var inning = eval( "match.innings" + i2 );
						while (inning) {
							matchInfo.teams[inning.battingteam].runs = inning.runs;
							matchInfo.teams[inning.battingteam].wickets = inning.wickets;
							matchInfo.teams[inning.battingteam].score = inning.runs + "/" + inning.wickets;
							matchInfo.teams[inning.battingteam].balls = inning.oversinballs;
							matchInfo.teams[inning.battingteam].overs = 
								Math.floor(inning.oversinballs / 6) + ( (inning.oversinballs % 6) / 10 ) ;
							matchInfo.teams[inning.battingteam].extras = inning.extras;
							if(inning.oversinballs > 0) {
								var length = String(inning.runrate).length;
								matchInfo.teams[inning.battingteam].runRate = 
								String(inning.runrate).substr(0, ( 4 > length ? length : 4 ) );
							}
							var j = 1;
							var batsman = eval( "inning.batsman" + j );
							if (batsman)	matchInfo.teams[inning.battingteam].batsmen = new Array();
							while (batsman) {
								var newBatsman = new Object();
								newBatsman.lastname = batsman.batsman.lastname;
								newBatsman.runs = 0 + batsman.runs;
								newBatsman.balls = 0 + batsman.balls;
								newBatsman.fours = 0 + batsman.fours;
								newBatsman.sixes = 0 + batsman.sixes;
								matchInfo.teams[inning.battingteam].batsmen.push(newBatsman);
								j++;
								batsman = eval( "inning.batsman" + j );
							}
							
							j = 1;
							var bowler = eval( "inning.bowler" + j );
							if (bowler)		matchInfo.teams[inning.bowlingteam].bowlers = new Array();
							while (bowler) {
								var newBowler = new Object();
								newBowler.lastname = bowler.bowler.lastname;
								newBowler.balls = 0 + bowler.oversinballs;
								newBowler.overs = 
									Math.floor(bowler.oversinballs / 6) + ( (bowler.oversinballs % 6) / 10 ) ;
								newBowler.runs = 0 + bowler.runs;
								newBowler.maidens = 0 + bowler.maidens;
								newBowler.wickets = 0 + bowler.wickets;
								matchInfo.teams[inning.bowlingteam].bowlers.push(newBowler);
								j++;
								bowler = eval( "inning.bowler" + j );
							}
							
							matchInfo.battingTeam = inning.battingteam;
							matchInfo.bowlingTeam = inning.bowlingteam;
							i2++;
							inning = eval( "match.innings" + i2 );
						}
						matches.push(matchInfo);
					}
					// Getting info of the next match
					if(content.nextmatch) {
						var nextMatch = content.nextmatch;
						var matchInfo = new matchInfoObject("nextmatch");
						matchInfo.matchName = "Coming Up";
						matchInfo.teams[0].id = nextMatch.team1id;
						matchInfo.teams[1].id = nextMatch.team2id;
						matchInfo.teams[0].name = nextMatch.team1name;
						matchInfo.teams[1].name = nextMatch.team2name;
						matchInfo.battingTeam = 0;
						matchInfo.bowlingTeam = 1;
						matchInfo.venue = nextMatch.venue;
						var nextSchedule = nextMatch.startdate;
						if( nextSchedule.substring(nextSchedule.length - 5, 
							nextSchedule.length).toLowerCase() == "(gmt)" )
							nextSchedule = nextSchedule.substring(0, nextSchedule.length - 5) + " GMT";
						matchInfo.status = new Date(nextSchedule).toLocaleString();
						matches.push(matchInfo);
					}
					if(matches.length == 0) {
						//failure++;
						var matchInfo = new matchInfoObject("error");
						matchInfo.matchName = "Error";
						matchInfo.errorMessage = "Oops! Servers nap too :(";
						matches.push(matchInfo);
					} else {
						hideElement("refreshButton");
					}
				}
			} catch (e) {
				//failure++;
				var matchInfo = new matchInfoObject("error");
				matchInfo.matchName = "Error";
				matchInfo.errorMessage = "Oops! Recieved garbage >:o";
				matches = new Array();
				matches.push(matchInfo);
			}
			showMatch();
		} else {
			failure++;
		}
		ajax = null;
		
		if (refreshTimer) {
			clearInterval(refreshTimer);
			refreshTimer = null;
		}
		if (failure < 3) {
			refreshTimer = setTimeout("refreshContent()", nextRefresh + Math.random() * 1000 - 500);
		} else {
			var matchInfo = new matchInfoObject("error");
			matchInfo.matchName = "Error";
			matchInfo.errorMessage = "Oops! Can't get through :-/";
			matches = new Array();
			matches.push(matchInfo);
			showMatch();
			//failure = 0;
		}
	}
}


function checkForUpdate()
{
	var lastChecked;
	var today = new Date();
	today.setHours(0, 0, 0, 0);
	if (window.widget) { lastChecked = widget.preferenceForKey("lastChecked"); }
	if (lastChecked == undefined) {	lastChecked = "Sat Mar 31 2007"; }
	lastChecked = new Date(lastChecked);
	lastChecked.setHours(0, 0, 0, 0);
	if (lastChecked < today) {
		getLatestVersion();
		if (window.widget) { widget.setPreferenceForKey(today.toString(), "lastChecked"); }
	}
}

function getLatestVersion()
{
	if (versionRequest != null) {
		versionRequest.abort();
		versionRequest = null;
	}
	versionRequest = new XMLHttpRequest();
	versionRequest.onreadystatechange = compareVersion;
	versionRequest.open("GET", updateURL);
	versionRequest.setRequestHeader("Cache-Control", "no-cache");
	versionRequest.send(null);
}

function compareVersion()
{
	if (versionRequest.readyState == 4 || versionRequest.readyState == 'complete') {
		if (versionRequest.status == 200) {
			try {
				latestVersion = Number(versionRequest.responseText);
				if (window.widget) {
					// Read the build number from the Info.plist file
					var currentVersion = widget.system("sh -c 'defaults read \"`pwd`/Info\" CFBundleVersion'",null).outputString;
					// removing the \n from the outputString
					currentVersion = Number(currentVersion);
					// Read the last ignored build number
					var ignoredVersion = widget.preferenceForKey("ignoredVersion");
					if (ignoredVersion == undefined) { ignoredVersion = 0; }
					else { ignoredVersion = Number(ignoredVersion); }
					if (latestVersion > currentVersion && latestVersion > ignoredVersion) { showUpdateSlider(); }
				}
				
			} catch (e) {
				// caught exception
			}
		}
		
		//http transaction complete
		versionRequest = null;
	}
}